<?php
class Wpg_WpgOnPage_ResponseController extends Mage_Core_Controller_Front_Action
{
    public function indexAction()
    {
        /** @var Wpg_WpgOnPage_Model_Gateway */
        $gateway = Mage::getModel('WpgOnPage/Gateway');
        $request = $this->getRequest();


        $hash_string = $request->getPost('id') . $request->getPost('order_number') . $request->getPost('order_amount') . $request->getPost('order_currency') . $request->getPost('order_description') . $gateway->getConfigData('secretkey');
        $hash = sha1(md5(strtoupper($hash_string)));

        //validation request
        if ($request->getPost('hash') != $hash) {
            exit('hash error');
        }

        $order_id = $request->getPost('order_number');
        $order = Mage::getModel('sales/order');

        /** @var Mage_Sales_Model_Order */
        $order->loadByIncrementId($order_id);

        if ($order->getStatus() == $gateway->getConfigData('order_status') || $order->getStatus() == 'pending') {

            if ($request->getPost('status') == 'success' && $request->getPost('type') == 'sale') {
                //successful purchase
                $order->setState($gateway->getConfigData('after_pay_status'));

                $order->sendNewOrderEmail();
                //$order->setEmailSent(true);

                //need generate transaction and invoice
                if ($order->canInvoice()) {

                    /** @var Mage_Sales_Model_Order_Payment */
                    $payment = $order->getPayment();
                    $payment->setTransactionId($request->getPost('id'))
                        ->setCurrencyCode($request->getPost('order_currency'))
                        ->setPreparedMessage('')

                        ->setIsTransactionClosed(true)
                        ->registerCaptureNotification(
                            $request->getPost('order_amount'),
                            false
                        );
                    $order->save();

                    // notify customer
                    $invoice = $payment->getCreatedInvoice();
                    if ($invoice && !$order->getEmailSent()) {
                        $order->queueNewOrderEmail()->addStatusHistoryComment(
                            Mage::helper('paypal')->__('Notified customer about ddsfdfdfdfdf invoice #%s.', $invoice->getIncrementId())
                        )
                            ->setIsCustomerNotified(true)
                            ->save();
                    }
                }

                Mage::getSingleton('checkout/session')->unsQuoteId();
                exit;
            }

            // if ($request->getPost('status') == 'waiting' && $request->getPost('type') == 'sale') {
            //     //waiting purchase
            //     //error_log('status fail sale');
            //     $order->update_status('on-hold', __('On hold', 'woocommerce'));
            //     exit;
            // }

            // if ($request->getPost('status') == 'fail' && $request->getPost('type') == 'sale') {
            //     //failed purchase
            //     //error_log('status fail sale');
            //     $order->update_status('failed', $_POST['reason']);
            //     exit;
            // }
        }

        // if ($order->get_status() == 'completed' || $order->get_status() == 'processing') {
        //     if ($_POST['status'] == 'success' && $_POST['type'] == 'refund') {
        //         //$order->update_status('refunded', __('Refunded', 'woocommerce'));
        //         $order->add_order_note('Refund confirmed by the payment system');
        //         exit;
        //     }
        //     if ($_POST['status'] == 'fail' && $_POST['type'] == 'refund') {
        //         $order->update_status('failed', $_POST['reason']);
        //         exit;
        //     }
        // }
    }
}
