<?php

class Wpg_WpgOnPage_Model_WpgOnPage extends Mage_Payment_Model_Method_Abstract
{

    protected $_code = 'WpgOnPage';
    protected $_formBlockType = 'WpgOnPage/form';

    protected $_isGateway = true;
    protected $_canRefund = true;
    protected $_canRefundInvoicePartial = true;

    public function getCheckout()
    {
        return Mage::getSingleton('checkout/session');
    }


    public function getQuote()
    {
        $orderIncrementId = $this->getCheckout()->getLastRealOrderId();
        $order = Mage::getModel('sales/order')->loadByIncrementId($orderIncrementId);

        return $order;
    }

    public function getOrderPlaceRedirectUrl()
    {
        $url = Mage::getUrl('WpgOnPage/redirect', array('_secure' => true));
        return $url;
    }

    public function refund(Varien_Object $payment, $amount)
    {
        $gateway = Mage::getModel('WpgOnPage/Gateway');
        if ($gateway->refund($payment->getOrder(), $amount)) {
            return parent::refund($payment, $amount);
        }
        return $this;
    }
}
