<?php

use Automattic\WooCommerce\Blocks\Package;
use Automattic\WooCommerce\Blocks\Domain\Services\CheckoutFields;

class Kunnect
{
    private $order;
    public function __construct($order_id)
    {
        $this->order = wc_get_order($order_id);
    }

    public function getParam()
    {
        $checkout_fields = Package::container()->get( CheckoutFields::class );
        $cryptoCurency = $checkout_fields->get_field_from_object( 'wpg/crypto-currency', $this->order, 'order' );

        if (empty($cryptoCurency)) {
            $cryptoCurency = $this->order->get_meta('wpg_crypto_currency');
        }

        if (in_array($cryptoCurency, WC_Web_Payment_Gateway::$cryptoCurencies));
        {
            $data['cryptoCurrency'] = $cryptoCurency;

            return $data;
        }

        $data['cryptoCurrency'] = '';

        return $data;
    }
}
