jQuery(document).ready(function ($) {

	jQuery('input#myprefix_media_manager').click(function (e) {

		e.preventDefault();
		var image_frame;
		if (image_frame) {
			image_frame.open();
		}
		// Define image_frame as wp.media object
		image_frame = wp.media({
			title: 'Select logo',
			multiple: false,
			library: {
				type: 'image',
			}
		});

		image_frame.on('close', function () {
			// On close, get selections and save to the hidden input
			// plus other AJAX stuff to refresh the image preview
			var selection = image_frame.state().get('selection');
			var gallery_ids = new Array();
			var my_index = 0;
			selection.each(function (attachment) {
				gallery_ids[my_index] = attachment['id'];
				my_index++;
			});
			var ids = gallery_ids.join(",");
			//jQuery('input.wpg_custom_logo').val(ids);
			Refresh_Image(ids);
			// Save_Image(ids);
		});

		image_frame.on('open', function () {
			// On open, get the id from the hidden input
			// and select the appropiate images in the media manager
			var selection = image_frame.state().get('selection');
			var ids = jQuery('input#woocommerce_wpgfull_icon').val().split(',');
			ids.forEach(function (id) {
				var attachment = wp.media.attachment(id);
				attachment.fetch();
				selection.add(attachment ? [attachment] : []);
			});

		});

		image_frame.open();
	});

	let urlTargetRow = jQuery('#woocommerce_wpgfull_url_target').closest('tr');

	jQuery('#woocommerce_wpgfull_iframe').change(function() {
		//let elem = jQuery(this);
		if (this.checked) {
			urlTargetRow.show();
		}else{
			urlTargetRow.hide();
		}
	});

	if (jQuery('#woocommerce_wpgfull_iframe')[0].checked) {
		urlTargetRow.show();
	}else{
		urlTargetRow.hide();
	}

	jQuery('#woocommerce_wpgfull_additional_payment_parameters').on("change", toggleBlocks);
	function toggleBlocks(e) {
		
		var selectedValues = $('#woocommerce_wpgfull_additional_payment_parameters').val() || [];

		// hide all first
		$("#woocommerce_wpgfull_additional_payment_parameters option").each(function () {
			$("#woocommerce_wpgfull_additional_payment_parameters_" + $(this).val()).closest('tr').hide();
		});



		// show only those related to selected values
		selectedValues.forEach(function (val) {
			$("#woocommerce_wpgfull_additional_payment_parameters_" + val).closest('tr').show();
		});
	}

	toggleBlocks();

});

// Ajax request to refresh the image preview
function Refresh_Image(the_id) {
	var data = {
		id: the_id
	};

	let url = jQuery('#wc_api_url').val();
	jQuery.get(url, data, function (response) {

		if (response.success === true) {
			jQuery('#wpg_custom_logo_prewiev').replaceWith(response.data.image);
			jQuery('input.wpg_custom_logo').val(response.data.imageurl);

		}
	});
}
