<?php
/**
* 2007-2021 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2021 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

use Psr\Log\LogLevel;

class WpGatewayProcessModuleFrontController extends ModuleFrontController
{

    public $currentTemplate = 'module:wpgateway/views/templates/front/errorpage.tpl';

    public $currencies_3dotexponent = ['BHD', 'JOD', 'KWD', 'OMR', 'TND'];
    public $currencies_noexponent = [
        //'CLP', 
        'VND',
        'ISK',
        'UGX',
        //'KRW', 
        //'JPY'
    ];

    public function initHeader()
    {
        $this->context->smarty->assign(array('errors' => array()));
        parent::initHeader();
        $this->setTemplate($this->currentTemplate);
    }

    public function initContent()
    {
        parent::initContent();
        $logger = $this->module->logger;

        $cart = $this->context->cart;

        if ($cart->nbProducts() <= 0) {
            $this->setErrorTemplate('Your shopping cart is empty');
        }
        $moduleActive = false;
        foreach (Module::getPaymentModules() as $module) {
            if ($module['name'] == 'wpgateway') {
                $moduleActive = true;
                break;
            }
        }

        if (!$moduleActive) {
            $this->setErrorTemplate('This payment method is not available.');
            return;
        }
        //generate request data
        $customer  = new Customer($cart->id_customer);
        $address       = new Address($cart->id_address_invoice);
        $country       = Country::getIsoById($address->id_country);

        $currency      = new Currency($cart->id_currency);
        $currency_code = trim($currency->iso_code);
        $total         = $cart->getOrderTotal(true, Cart::BOTH);
        $amount        = $this->formatPrice($total, $currency_code);


        // $successurl = $this->context->link->getPageLink(
        //     'order-confirmation',
        //     true,
        //     null,
        //     array(
        //       'id_cart' => (int) $cart->id,
        //       'id_module' => (int) $this->module->id,
        //       'key' => $customer->secure_key
        //     ),
        //     true
        // );

        // $query = [
        //     'id_cart' => (int) $cart->id,
        //     'id_module' => (int) $this->module->id,
        //     'key' => $customer->secure_key,
        //     'id_lang' => $this->context->language->id,
        // ];

        // http_build_query($query);



        $successurl = $this->context->link->getModuleLink(
            'wpgateway',
            'confirmation',
            [
                'id_cart' => (int) $cart->id,
                'id_module' => (int) $this->module->id,
                'key' => $customer->secure_key,
            ],
            true,
            $this->context->language->id
        );

        $failurl = $this->context->link->getModuleLink(
            'wpgateway',
            'cancel',
            [
                'cart_id' => $this->context->cart->id,
                'secure_key' => $this->context->customer->secure_key
            ],
            true
        );

        $state_val = null;

        if (in_array($country, array('US','CA'))) {
            $state = new State((int)$address->id_state);
            if (Validate::isLoadedObject($state)) {
                $state_val = $state->iso_code;
            } else {
                $state_val = 'NA';
            }
        }

        $phone = ($address->phone) ? $address->phone : $address->phone_mobile;

        $customerinfo = array(
            'name'  => $customer->firstname . ' ' . $customer->lastname,
            'email' => $customer->email,
        );
        $billing_address = array(
            'country'   => $country,
            'state'     => $state_val,
            'city'      => $address->city,
            'address'   => $address->address1.' '.$address->address2,
            'zip'       => $address->postcode,
            'phone'     => $phone,
        );
        $order_json = array(
            'number'        => "$cart->id",
            'description'   => $this->module->l("Payment Order #$cart->id"),
            'amount'        => $amount, //may troubles
            'currency'      => $currency_code,
        );

        $str_to_hash = $cart->id . $amount . $currency_code .
            $this->module->l("Payment Order #$cart->id") . Configuration::get('WPG_MERCHANT_PASSWORD');

        $hash = sha1(md5(Tools::strtoupper($str_to_hash)));
        
        $main_json = array(
            'merchant_key' => Configuration::get('WPG_MERCHANT_KEY'),
            'operation'    => 'purchase', //m subs purchase
            'order'        => $order_json,
            'customer'     => $customerinfo,
            'billing_address' => $billing_address,
            'success_url'  => $successurl,
            'cancel_url'   => $failurl, //
            'hash'         => $hash
        );

        $methods = unserialize(Configuration::get('WPG_METHOD')); //may error
        if (!empty($methods)) {
             $main_json['methods'] = $methods;
        }
 

        $json = json_encode($main_json, JSON_UNESCAPED_UNICODE);

        if (_PS_MODE_DEV_ == true) {
            $logger->log(LogLevel::DEBUG, 'ProcessJson: '.$json);
        }

        $link = rtrim(Configuration::get('WPG_CHECKOUT'), '/').$this->module->apiMethod['checkout'];
        $getter = curl_init($link); //init curl
        curl_setopt($getter, CURLOPT_POST, 1); //post
        curl_setopt($getter, CURLOPT_POSTFIELDS, $json); //json
        curl_setopt($getter, CURLOPT_HTTPHEADER, array('Content-Type:application/json')); //header
        curl_setopt($getter, CURLOPT_RETURNTRANSFER, true);

        $result = curl_exec($getter);
        $httpcode = curl_getinfo($getter, CURLINFO_HTTP_CODE);

        if (_PS_MODE_DEV_ == true) {
            //$response = json_decode($result, true);
            $logger->log(LogLevel::DEBUG, 'ProcessHttpCode: '.$httpcode);
            $logger->log(LogLevel::DEBUG, 'ProcessJson: '.$result);
        }

        $response = json_decode($result, true);

        if ($httpcode != 200) {
            $this->setErrorTemplate('Payment error. Contact support');
            return;
        }

        $this->module->validateOrder(
            $cart->id,
            Configuration::get('WPG_STATE_WAITING'),
            $total,
            $this->module->displayName,
            null,
            array(),
            (int)$currency->id,
            false,
            $customer->secure_key
        );
        // $id_cart,
        // $id_order_state,
        // $amount_paid,
        // $payment_method = 'Unknown',
        // $message = null,
        // $extra_vars = [],
        // $currency_special = null,
        // $dont_touch_amount = false,
        // $secure_key = false,
        // Shop $shop = null

        
        Tools::redirectLink($response['redirect_url']);
        return true;
    }
    protected function setErrorTemplate($processingReturnCode, $setTemplate = true)
    {
        if ($setTemplate) {
            $this->setTemplate("module:wpgateway/views/templates/front/errorpage.tpl");
        }
        $translation = $this->module->l($processingReturnCode);
        // if ($translation === $processingReturnCode) {
        //     $translation = $this->module->l(
        //         'An error occurred while processing payment code: ' . $translation
        //     );
        // }
        $this->context->smarty->assign(
            array(
                'errors' => array($translation)
            )
        );
    }

    protected function formatPrice($total, $currency_code)
    {
        $amount = number_format($total, 2, '.', '');
        if (in_array($currency_code, $this->currencies_noexponent)) {
            $amount = number_format($total, 0, '.', '');
        } elseif (in_array($currency_code, $this->currencies_3dotexponent)) {
            $amount = number_format($total, 3, '.', '');
        }
        return $amount;
    }
}
