<?php
/**
* 2007-2021 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2021 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

use Psr\Log\LogLevel;

class WpGatewayCallbackModuleFrontController extends ModuleFrontController
{
    public $currentTemplate = 'module:wpgateway/views/templates/front/callback.tpl';


    public function initContent()
    {
        parent::initContent();
        $this->setTemplate($this->currentTemplate);
    //     //$this->setMessage('Go away');
        return $this->processCallback();
    }


    public function processCallback()
    {
        $logger = $this->module->logger;

        if (_PS_MODE_DEV_ == true) {
            $logger->log(LogLevel::DEBUG, 'CallbackReciveData:'.print_r($_POST, true));
        }
 
        if ((Tools::getIsset('hash') && Tools::getIsset('id') && Tools::getIsset('order_number')) === false) {
            if (_PS_MODE_DEV_ == true) {
                $logger->log(LogLevel::DEBUG, 'Callback: Invalid data');
            }
            return $this->setMessage('Invalid data');
        }

        $hash_string = Tools::getValue('id') . Tools::getValue('order_number') . Tools::getValue('order_amount') .
            Tools::getValue('order_currency') . Tools::getValue('order_description') . Configuration::get('WPG_MERCHANT_PASSWORD');
            
        $hash = sha1(md5(Tools::strtoupper($hash_string)));

        if (Tools::getValue('hash') != $hash) {
            if (_PS_MODE_DEV_ == true) {
                $logger->log(LogLevel::DEBUG, 'Callback: Unathorized');
            }
            return $this->setMessage('Unathorized');
        }
        //process order
        $cart = new Cart(Tools::getValue('order_number'));
        if (!Validate::isLoadedObject($cart)) {
            if (_PS_MODE_DEV_ == true) {
                $logger->log(LogLevel::DEBUG, 'Callback: Error load cart');
            }
            return $this->setMessage('Error load cart');
        }
        $orderId = (int)Order::getIdByCartId((int)$cart->id);
        $order    = new Order($orderId);
        //$currency = new Currency((int)($cart->id_currency));


        if (Tools::getValue('status') == 'success' && Tools::getValue('type') == 'sale') {
            //successful purchase
            if (_PS_MODE_DEV_ == true) {
                $logger->log(LogLevel::DEBUG, 'Callback: successful purchase');
            }
            $status = Configuration::get('PS_OS_PAYMENT');
            $order->setCurrentState($status);
            $this->saveOrderTransactionData(Tools::getValue('id'), $this->module->name, $orderId);
            exit;
        }

        if (Tools::getValue('status') == 'waiting' && Tools::getValue('type') == 'sale') {
            if (_PS_MODE_DEV_ == true) {
                $logger->log(LogLevel::DEBUG, 'Callback: waiting purchase');
            }
            exit;
        }

        if (Tools::getValue('status') == 'fail' && Tools::getValue('type') == 'sale') {
            if (_PS_MODE_DEV_ == true) {
                $logger->log(LogLevel::DEBUG, 'Callback: failed purchase');
            }
            $status = Configuration::get('PS_OS_ERROR');
            $order->setCurrentState($status);
            $this->saveOrderTransactionData(Tools::getValue('id'), $this->module->name, $orderId);
            exit;
        }

        
        if (Tools::getValue('status') == 'success' && Tools::getValue('type') == 'refund') {
            if (_PS_MODE_DEV_ == true) {
                $logger->log(LogLevel::DEBUG, 'Callback: refund succesful');
            }
            //_PS_OS_REFUND_
            $status = Configuration::get('PS_OS_REFUND');
            $order->setCurrentState($status);
            $this->saveOrderTransactionData(Tools::getValue('id'), $this->module->name, $orderId);
            exit;
        }
    }
    private function saveOrderTransactionData($transactionId, $paymentMethod, $orderId)
    {
        // retrieve ALL payments of order.
        // if no OrderPayment objects is retrieved in the collection, do nothing.
        $order = new Order((int) $orderId);
        $collection = OrderPayment::getByOrderReference($order->reference);
        if (count($collection) > 0) {
            $orderPayment = $collection[0];
            // for older versions (1.5) , we check if it hasn't been filled yet.
            if (!$orderPayment->transaction_id) {
                $orderPayment->transaction_id = $transactionId;
                $orderPayment->payment_method = $paymentMethod;
                $orderPayment->update();
            }
        }
    }
    protected function setMessage($message)
    {
        $this->context->smarty->assign(
            array(
                'result' => $message
            )
        );
        return $message;
    }
}
